/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.ingame;

@FunctionalInterface
public interface InputCurve {
    public double apply(double var1);

    public static InputCurve power(double exponent) {
        return d -> Math.signum(d) * Math.pow(Math.abs(d), exponent);
    }

    public static InputCurve cubicBlend(double blendFactor) {
        return d -> {
            double mag = Math.abs(d);
            double blended = (1.0 - blendFactor) * mag + blendFactor * mag * mag * mag;
            return Math.signum(d) * blended;
        };
    }

    public static InputCurve sCurve() {
        return d -> {
            double mag = Math.abs(d);
            double sCurved = mag * mag * (3.0 - 2.0 * mag);
            return Math.signum(d) * sCurved;
        };
    }
}

