/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui;

import com.demonwav.mcdev.annotations.Translatable;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import traben.entity_texture_features.ETF;
import traben.tconfig.gui.TConfigEntryListWidget;
import traben.tconfig.gui.TConfigScreen;
import traben.tconfig.gui.entries.TConfigEntry;

public class TConfigScreenList
extends TConfigScreen {
    private final TConfigEntry[] options;
    private final Align align;
    protected boolean fullWidthBackgroundEvenIfSmaller = false;
    private Renderable renderFeature = null;
    private TConfigEntryListWidget list;
    private final class_342 search;

    public TConfigScreenList(@Translatable String title, class_437 parent, TConfigEntry[] options, Runnable resetValuesToDefault, Runnable undoChanges, Align align) {
        super(title, parent, true);
        this.options = options;
        this.parent = parent;
        this.resetDefaultValuesRunnable = resetValuesToDefault;
        this.undoChangesRunnable = undoChanges;
        this.align = align;
        if (options.length > 12) {
            this.search = new class_342(class_310.method_1551().field_1772, 4, 0, 120, 20, (class_2561)class_2561.method_43470((String)""));
            this.search.method_1863(this::updateSearch);
            this.search.method_47404(ETF.getTextFromTranslation("config.entity_features.search"));
        } else {
            this.search = null;
        }
    }

    public TConfigScreenList(@Translatable String title, class_437 parent, TConfigEntry[] options, Runnable resetValuesToDefault, Runnable undoChanges) {
        this(title, parent, options, resetValuesToDefault, undoChanges, Align.CENTER);
    }

    public void setRenderFeature(Renderable renderFeature) {
        this.renderFeature = renderFeature;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.renderFeature != null) {
            this.renderFeature.render(context, mouseX, mouseY);
        }
    }

    public void setWidgetBackgroundToFullWidth() {
        this.fullWidthBackgroundEvenIfSmaller = true;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.search != null) {
            int y = (int)((double)this.field_22790 * 0.15) - 24;
            int width = (int)((double)this.field_22789 * 0.2);
            this.search.method_46419(y);
            this.search.method_25358(width);
            this.method_37063((class_364)this.search);
        }
        this.initList(this.options);
    }

    private void updateSearch(String searchText) {
        assert (this.search != null);
        this.method_37066((class_364)this.list);
        ArrayList list = new ArrayList();
        if (searchText.isBlank()) {
            this.initList(this.options);
        } else {
            Arrays.stream(this.options).filter(it -> it.getText().getString().contains(searchText)).forEach(list::add);
            this.initList(list.toArray(new TConfigEntry[0]));
        }
    }

    private void initList(TConfigEntry[] subList) {
        int width;
        this.list = (TConfigEntryListWidget)this.method_37063((class_364)new TConfigEntryListWidget(width, (int)((double)this.field_22790 * 0.7), (int)((double)this.field_22790 * 0.15), switch (this.align.ordinal()) {
            case 0 -> {
                width = (int)((double)this.field_22789 * 0.3);
                yield (int)((double)this.field_22789 * 0.1);
            }
            case 2 -> {
                width = (int)((double)this.field_22789 * 0.3);
                yield (int)((double)this.field_22789 * 0.6);
            }
            default -> {
                width = this.field_22789;
                yield 0;
            }
        }, 24, subList));
        if (this.fullWidthBackgroundEvenIfSmaller) {
            this.list.setWidgetBackgroundToFullWidth();
        }
        this.list.method_44382(0.0);
    }

    public static interface Renderable {
        public void render(class_332 var1, int var2, int var3);
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

