/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.utils;

import btw.lowercase.skyboxify.skybox.components.Range;
import btw.lowercase.skyboxify.skybox.components.Weather;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserCodecs {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserCodecs.class);
    public static final Codec<String> TRIMMED_STRING = Codec.STRING.xmap(String::trim, String::valueOf);
    public static final Codec<List<String>> SPLIT_SPACE_TRIMMED = TRIMMED_STRING.xmap(input -> Arrays.stream(input.split(" ")).map(String::trim).filter(s -> !s.isEmpty()).toList(), list -> Arrays.toString(list.toArray()));
    public static final Codec<Float> SAFE_FLOAT = TRIMMED_STRING.comapFlatMap(input -> {
        try {
            return DataResult.success((Object)Float.valueOf(Float.parseFloat(input)));
        }
        catch (NumberFormatException exception) {
            return DataResult.error(exception::getMessage);
        }
    }, String::valueOf);
    public static final Codec<Integer> SAFE_INTEGER = TRIMMED_STRING.comapFlatMap(input -> {
        try {
            return DataResult.success((Object)Integer.parseInt(input));
        }
        catch (NumberFormatException exception) {
            return DataResult.error(exception::getMessage);
        }
    }, String::valueOf);
    public static final Codec<List<Weather>> WEATHER = SPLIT_SPACE_TRIMMED.xmap(input -> {
        if (!input.isEmpty()) {
            return (List)Weather.CODEC.listOf().parse((DynamicOps)JavaOps.INSTANCE, input).getOrThrow();
        }
        return List.of(Weather.CLEAR);
    }, list -> list.stream().map(Weather::method_15434).toList());
    public static final Codec<Vector3fc> AXIS = TRIMMED_STRING.xmap(input -> {
        Vector3f vector3f;
        List parts = (List)SPLIT_SPACE_TRIMMED.parse((DynamicOps)JavaOps.INSTANCE, (Object)input.replaceAll(" +", " ")).getOrThrow();
        if (parts.size() == 3 && (vector3f = new Vector3f(ParserCodecs.safeParseFloat((String)parts.get(0), Float.MIN_VALUE), ParserCodecs.safeParseFloat((String)parts.get(1), Float.MIN_VALUE), ParserCodecs.safeParseFloat((String)parts.get(2), Float.MIN_VALUE))).lengthSquared() > 1.0E-5f) {
            return new Vector3f(vector3f.z, vector3f.y, -vector3f.x);
        }
        LOGGER.warn("Invalid axis provided in skybox, returning default axis (Mth.X_AXIS).");
        return class_3532.field_46243;
    }, output -> String.format("%s %s %s", Float.valueOf(output.x()), Float.valueOf(output.y()), Float.valueOf(output.z())));

    private static Codec<Range> getRangeEntryCodec(boolean allowNegative) {
        int minValue = allowNegative ? Integer.MIN_VALUE : -1;
        return TRIMMED_STRING.xmap(input -> {
            if (input.contains("-")) {
                String[] parts = input.split("-");
                if (parts.length == 2) {
                    int min = ParserCodecs.safeParseInteger(parts[0], minValue);
                    int max = ParserCodecs.safeParseInteger(parts[1], minValue);
                    if (!allowNegative ? min >= 0 && max >= 0 : min != Integer.MIN_VALUE && max != Integer.MIN_VALUE) {
                        return new Range(min, max);
                    }
                }
            } else {
                String croppedInput = !allowNegative ? input : (input.startsWith("(") && input.endsWith(")") ? input.substring(1, input.length() - 1) : input);
                int value = ParserCodecs.safeParseInteger(croppedInput, minValue);
                if (!allowNegative ? value >= 0 : value != Integer.MIN_VALUE) {
                    return new Range(value, value);
                }
            }
            return null;
        }, Range::toString);
    }

    public static Codec<List<Range>> getRangeEntriesCodec(boolean allowNegative) {
        return TRIMMED_STRING.xmap(input -> {
            ArrayList<Range> entries = new ArrayList<Range>();
            for (String part : input.split("\\s*,\\s*|\\s+")) {
                Range range = (Range)ParserCodecs.getRangeEntryCodec(allowNegative).parse((DynamicOps)JavaOps.INSTANCE, (Object)part).getOrThrow();
                if (range == null) continue;
                entries.add(range);
            }
            return entries;
        }, output -> Arrays.toString(output.stream().map(Range::toString).toArray()));
    }

    public static Codec<class_2960> getSourceTextureCodec(class_2960 propertiesLocation) {
        return Codec.STRING.comapFlatMap(input -> {
            if (input == null) {
                return DataResult.success((Object)propertiesLocation.method_45136(propertiesLocation.method_12832().replace(".properties", ".png")));
            }
            if (input.startsWith("./")) {
                String fileName = propertiesLocation.method_12832().split("/")[propertiesLocation.method_12832().split("/").length - 1];
                return DataResult.success((Object)propertiesLocation.method_45136(propertiesLocation.method_12832().replace(fileName, input.substring(2))));
            }
            String[] parts = input.split("/", 3);
            if (parts.length == 3 && parts[0].equals("assets")) {
                return DataResult.success((Object)class_2960.method_60655((String)parts[1], (String)parts[2]));
            }
            class_2960 result = class_2960.method_12829((String)input);
            if (result != null) {
                return DataResult.success((Object)result);
            }
            return DataResult.error(() -> String.format("Failed to read texture source '%s' as resource location", input));
        }, class_2960::toString);
    }

    public static float safeParseFloat(String value, float defaultValue) {
        return ((Float)SAFE_FLOAT.orElse((Object)Float.valueOf(defaultValue)).parse((DynamicOps)JavaOps.INSTANCE, (Object)value).getOrThrow()).floatValue();
    }

    public static int safeParseInteger(String value, int defaultValue) {
        return (Integer)SAFE_INTEGER.orElse((Object)defaultValue).parse((DynamicOps)JavaOps.INSTANCE, (Object)value).getOrThrow();
    }

    public static <T> String emptyCodecString(T output) {
        return "";
    }
}

