/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.animation;

import io.github.foundationgames.animatica.Animatica;
import io.github.foundationgames.animatica.animation.AnimatedTexture;
import io.github.foundationgames.animatica.animation.AnimationMeta;
import io.github.foundationgames.animatica.util.Flags;
import io.github.foundationgames.animatica.util.exception.PropertyParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public final class AnimationLoader
implements SimpleSynchronousResourceReloadListener {
    public static final String[] ANIM_PATHS = new String[]{"animatica/anim", "mcpatcher/anim", "optifine/anim"};
    private static final class_2960 ID = Animatica.id("animation_storage");
    public static final AnimationLoader INSTANCE = new AnimationLoader();
    private final Map<class_2960, class_2960> animationIds = new HashMap<class_2960, class_2960>();

    private AnimationLoader() {
    }

    private static void findAllMCPAnimations(class_3300 manager, BiConsumer<class_2960, class_3298> action) {
        for (String path : ANIM_PATHS) {
            manager.method_14488(path, p -> p.method_12832().endsWith(".properties")).forEach(action);
        }
    }

    @Nullable
    public class_2960 getAnimationId(class_2960 id) {
        return this.animationIds.get(id);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        this.animationIds.clear();
        if (!Animatica.CONFIG.animatedTextures) {
            return;
        }
        Flags.ALLOW_INVALID_ID_CHARS = true;
        HashMap animations = new HashMap();
        AnimationLoader.findAllMCPAnimations(manager, (id, resource) -> {
            try (InputStream resourceInputStream = resource.method_14482();){
                Properties ppt = new Properties();
                ppt.load(resourceInputStream);
                AnimationMeta anim = AnimationMeta.of(id, ppt);
                class_2960 targetId = anim.target();
                if (!animations.containsKey(targetId)) {
                    animations.put(targetId, new ArrayList());
                }
                ((List)animations.get(targetId)).add(anim);
            }
            catch (PropertyParseException | IOException e) {
                Animatica.LOG.error(e.getMessage());
            }
        });
        for (class_2960 targetId : animations.keySet()) {
            AnimatedTexture.tryCreate(manager, targetId, (List)animations.get(targetId)).ifPresent(tex -> {
                class_2960 animId = class_2960.method_60655((String)targetId.method_12836(), (String)(targetId.method_12832() + "-anim"));
                this.animationIds.put(targetId, animId);
                class_310.method_1551().method_1531().method_4616(animId, (class_1044)tex);
            });
        }
        Flags.ALLOW_INVALID_ID_CHARS = false;
    }
}

