/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.kir.cubeswithoutborders.client.FullscreenManager;
import dev.kir.cubeswithoutborders.client.FullscreenMode;
import dev.kir.cubeswithoutborders.client.FullscreenType;
import dev.kir.cubeswithoutborders.client.FullscreenTypes;
import dev.kir.cubeswithoutborders.client.MonitorInfo;
import dev.kir.cubeswithoutborders.client.MonitorLookup;
import dev.kir.cubeswithoutborders.client.ResizableGameRenderer;
import dev.kir.cubeswithoutborders.client.config.CubesWithoutBordersConfig;
import dev.kir.cubeswithoutborders.client.util.SystemUtil;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_313;
import net.minecraft.class_315;
import net.minecraft.class_319;
import net.minecraft.class_323;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1041.class})
abstract class WindowMixin
implements FullscreenManager {
    @Shadow
    @Final
    private class_323 field_5195;
    @Shadow
    private Optional<class_319> field_5193;
    @Shadow
    private int field_5175;
    @Shadow
    private int field_5185;
    @Shadow
    private int field_5174;
    @Shadow
    private int field_5184;
    @Shadow
    private boolean field_5191;
    @Shadow
    private boolean field_5177;
    private boolean borderless;
    private FullscreenType previousFullscreenType;
    private FullscreenType currentFullscreenType;

    WindowMixin() {
    }

    @Override
    public FullscreenMode getFullscreenMode() {
        return this.field_5191 ? (this.borderless ? FullscreenMode.BORDERLESS : FullscreenMode.ON) : FullscreenMode.OFF;
    }

    @Override
    public void setFullscreenMode(FullscreenMode fullscreenMode) {
        FullscreenMode currentFullscreenMode = this.getFullscreenMode();
        boolean bl = this.field_5191 = fullscreenMode != FullscreenMode.OFF;
        this.borderless = this.field_5191 ? fullscreenMode == FullscreenMode.BORDERLESS : this.borderless;
        this.field_5177 = currentFullscreenMode == fullscreenMode == this.field_5191;
        class_310.method_1551().field_1690.method_42447().method_41748((Object)this.field_5191);
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/MonitorTracker;getMonitor(J)Lnet/minecraft/client/util/Monitor;")})
    private class_313 fixupMonitor(class_323 monitorTracker, long pointer, Operation<class_313> getMonitor) {
        this.field_5177 = false;
        this.field_5191 = false;
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        class_313 monitor = (class_313)getMonitor.call(new Object[]{monitorTracker, pointer});
        Optional<class_313> preferredMonitor = MonitorLookup.findMonitor(monitorTracker, config.getPreferredMonitor());
        return SystemUtil.isWindows() ? preferredMonitor.orElse(monitor) : monitor;
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/Window;updateWindowRegion()V")})
    private void init(class_1041 window, Operation<Void> updateWindowRegion) {
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        this.field_5177 = config.getFullscreenMode() != FullscreenMode.OFF;
        this.field_5191 = this.field_5177;
        this.borderless = config.getPreferredFullscreenMode() == FullscreenMode.BORDERLESS;
        this.borderless = this.borderless || config.getFullscreenMode() == FullscreenMode.BORDERLESS;
        this.currentFullscreenType = null;
        this.previousFullscreenType = null;
        class_313 currentMonitor = this.field_5195.method_1681(window);
        class_313 preferredMonitor = MonitorLookup.findMonitor(this.field_5195, config.getPreferredMonitor()).orElse(currentMonitor);
        if (preferredMonitor != currentMonitor && SystemUtil.isWindows()) {
            class_319 videoMode = preferredMonitor.method_1617();
            this.field_5175 = window.field_5183 = preferredMonitor.method_1616() + (videoMode.method_1668() - window.field_5182) / 2;
            this.field_5185 = window.field_5198 = preferredMonitor.method_1618() + (videoMode.method_1669() - window.field_5197) / 2;
            GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)0L, (int)window.field_5183, (int)window.field_5198, (int)window.field_5182, (int)window.field_5197, (int)-1);
        }
        updateWindowRegion.call(new Object[]{window});
    }

    @Inject(method={"updateWindowRegion"}, at={@At(value="HEAD")}, cancellable=true)
    private void enableFullscreen(CallbackInfo ci) {
        boolean wasInWindowedMode;
        class_1041 window = (class_1041)this;
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        this.previousFullscreenType = this.currentFullscreenType;
        if (!this.field_5191) {
            this.currentFullscreenType = null;
            return;
        }
        FullscreenType requestedFullscreenType = this.borderless ? config.getBorderlessFullscreenType() : config.getFullscreenType();
        FullscreenType defaultFullscreenType = this.borderless ? FullscreenTypes.borderless() : FullscreenTypes.exclusive();
        this.currentFullscreenType = FullscreenTypes.validate(requestedFullscreenType, defaultFullscreenType);
        class_313 monitor = this.field_5195.method_1681(window);
        if (monitor == null) {
            this.currentFullscreenType = null;
            return;
        }
        if (this.currentFullscreenType == FullscreenTypes.DEFAULT) {
            return;
        }
        boolean bl = wasInWindowedMode = this.previousFullscreenType == null;
        if (wasInWindowedMode) {
            this.field_5175 = window.field_5183;
            this.field_5185 = window.field_5198;
            this.field_5174 = window.field_5182;
            this.field_5184 = window.field_5197;
        } else {
            this.previousFullscreenType.disable(window);
            ResizableGameRenderer.getInstance().disable();
        }
        class_319 videoMode = monitor.method_1614(this.field_5193);
        this.currentFullscreenType.enable(window, monitor, videoMode);
        int targetWidth = videoMode.method_1668();
        int targetHeight = videoMode.method_1669();
        int deltaWidth = Math.abs(window.field_5182 - targetWidth);
        int deltaHeight = Math.abs(window.field_5197 - targetHeight);
        if (deltaWidth > 1 || deltaHeight > 1) {
            float targetScale = Math.min((float)targetWidth / (float)window.field_5182, (float)targetHeight / (float)window.field_5197);
            int scaledWidth = Math.round((float)window.field_5182 * targetScale);
            int scaledHeight = Math.round((float)window.field_5197 * targetScale);
            ResizableGameRenderer.getInstance().resize(scaledWidth, scaledHeight);
        }
        ci.cancel();
    }

    @Inject(method={"updateWindowRegion"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwSetWindowMonitor(JJIIIII)V", ordinal=0), @At(value="FIELD", target="Lnet/minecraft/client/util/Window;windowedX:I", ordinal=1)})
    private void disableFullscreen(CallbackInfo ci) {
        if (this.previousFullscreenType == null) {
            return;
        }
        this.previousFullscreenType.disable((class_1041)this);
        ResizableGameRenderer.getInstance().disable();
    }

    @WrapOperation(method={"updateWindowRegion"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwGetWindowMonitor(J)J", ordinal=0)})
    private long getWindowMonitorIfWindowed(long handle, Operation<Long> getWindowMonitor) {
        if (this.previousFullscreenType != null) {
            return -1L;
        }
        return (Long)getWindowMonitor.call(new Object[]{handle});
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    private void save(CallbackInfo ci) {
        class_1041 window = (class_1041)this;
        class_313 monitor = this.field_5195.method_1681(window);
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        config.setFullscreenMode(this.getFullscreenMode());
        config.setPreferredFullscreenMode(this.borderless ? FullscreenMode.BORDERLESS : FullscreenMode.ON);
        config.setPreferredMonitor(monitor == null ? MonitorInfo.primary() : MonitorInfo.of(monitor));
        config.save();
        class_315 options = class_310.method_1551().field_1690;
        options.method_42447().method_41748((Object)this.field_5191);
        options.method_1640();
    }
}

