/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass;

import dev.ultimatchamp.bettergrass.compat.WilderWildCompat;
import dev.ultimatchamp.bettergrass.config.BetterGrassifyConfig;
import dev.ultimatchamp.bettergrass.model.BetterGrassifyUnbakedRootBlockStateModel;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2344;
import net.minecraft.class_2369;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterGrassify
implements ClientModInitializer {
    public static final String MOD_NAME = "BetterGrassify";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"BetterGrassify");

    public void onInitializeClient() {
        BetterGrassifyConfig config = BetterGrassifyConfig.load();
        if (config.general.betterGrassMode.equals((Object)BetterGrassifyConfig.BetterGrassMode.OFF)) {
            LOGGER.info("[{}] Better Grass is disabled! ;(", (Object)MOD_NAME);
        } else {
            LOGGER.info("[{}] [{}] Gamers can finally touch grass!?", (Object)MOD_NAME, (Object)config.general.betterGrassMode);
        }
        if (FabricLoader.getInstance().isModLoaded("wilderwild") && WilderWildCompat.isSnowloggingOn()) {
            config.general.blocks.snowy = false;
            config.betterSnow.betterSnowMode = BetterGrassifyConfig.BetterSnowMode.OFF;
            BetterGrassifyConfig.save(config);
            LOGGER.warn("[{}] 'WilderWild' detected. 'Better Snowy Grass' and 'Better Snow' features have been disabled.", (Object)MOD_NAME);
        }
        ModelLoadingPlugin.register(pluginContext -> pluginContext.modifyBlockModelOnLoad().register(ModelModifier.WRAP_LAST_PHASE, (model, context) -> {
            class_2680 state = context.state();
            List<String> blocks = BetterGrassify.getBlocks();
            for (String blockId : blocks) {
                class_2248 block = class_7923.field_41175.method_17966(class_2960.method_12829((String)blockId)).orElse(null);
                if (state.method_27852(block)) {
                    if (state.method_28500((class_2769)class_2741.field_12512).orElse(false).booleanValue()) {
                        if (!BetterGrassifyConfig.load().general.blocks.snowy) continue;
                        return new BetterGrassifyUnbakedRootBlockStateModel(model);
                    }
                    return new BetterGrassifyUnbakedRootBlockStateModel(model);
                }
                if (!state.method_27852(class_2246.field_10566) || !(block instanceof class_2369) && !(block instanceof class_2344)) continue;
                return new BetterGrassifyUnbakedRootBlockStateModel(model);
            }
            return model;
        }));
    }

    public static List<String> getBlocks() {
        BetterGrassifyConfig.GeneralConfig.BlocksConfig config = BetterGrassifyConfig.load().general.blocks;
        ArrayList<String> blocks = new ArrayList<String>();
        if (config.grassBlocks) {
            blocks.add("minecraft:grass_block");
        }
        if (config.dirtPaths) {
            blocks.add("minecraft:dirt_path");
        }
        if (config.farmLands) {
            blocks.add("minecraft:farmland");
        }
        if (config.podzol) {
            blocks.add("minecraft:podzol");
        }
        if (config.mycelium) {
            blocks.add("minecraft:mycelium");
        }
        if (config.crimsonNylium) {
            blocks.add("minecraft:crimson_nylium");
        }
        if (config.warpedNylium) {
            blocks.add("minecraft:warped_nylium");
        }
        blocks.addAll(config.moreBlocks);
        return blocks;
    }
}

