/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.mainmenucredits;

import com.mojang.logging.LogUtils;
import dev.isxander.mainmenucredits.api.MainMenuCreditAPI;
import dev.isxander.mainmenucredits.config.MMCConfig;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import org.slf4j.Logger;

public class MainMenuCredits
implements ClientModInitializer {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static MainMenuCredits instance;
    private MMCConfig config;

    public void onInitializeClient() {
        instance = this;
        this.config = new MMCConfig();
        this.config.load();
        List entrypoints = FabricLoader.getInstance().getEntrypointContainers("main-menu-credits", MainMenuCreditAPI.class);
        for (EntrypointContainer container : entrypoints) {
            MainMenuCreditAPI api = (MainMenuCreditAPI)container.getEntrypoint();
            if (!this.config.MAIN_MENU.getModBlacklist().contains(container.getProvider().getMetadata().getId())) {
                this.config.MAIN_MENU.getTopLeft().addAll(api.getTitleScreenTopLeft());
                this.config.MAIN_MENU.getTopRight().addAll(api.getTitleScreenTopRight());
                this.config.MAIN_MENU.getBottomLeft().addAll(api.getTitleScreenBottomLeft());
                this.config.MAIN_MENU.getBottomRight().addAll(api.getTitleScreenBottomRight());
            }
            if (this.config.PAUSE_MENU.getModBlacklist().contains(container.getProvider().getMetadata().getId())) continue;
            this.config.PAUSE_MENU.getTopLeft().addAll(api.getPauseScreenTopLeft());
            this.config.PAUSE_MENU.getTopRight().addAll(api.getPauseScreenTopRight());
            this.config.PAUSE_MENU.getBottomLeft().addAll(api.getPauseScreenBottomLeft());
            this.config.PAUSE_MENU.getBottomRight().addAll(api.getPauseScreenBottomRight());
        }
    }

    public MMCConfig getConfig() {
        return this.config;
    }

    public static MainMenuCredits getInstance() {
        return instance;
    }
}

