/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.AbstractTabbedConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigTabButton;
import me.shedaniel.clothconfig2.gui.entries.EmptyEntry;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.SearchFieldEntry;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_9848;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ClothConfigScreen
extends AbstractTabbedConfigScreen {
    private final ScrollingContainer tabsScroller = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(0, 0, 1, ClothConfigScreen.this.field_22789 - 40);
        }

        @Override
        public int getMaxScrollHeight() {
            return (int)ClothConfigScreen.this.getTabsMaximumScrolled();
        }

        @Override
        public void updatePosition(float delta) {
            super.updatePosition(delta);
            this.setScrollTarget(this.clamp(this.scrollTarget(), 0.0));
        }
    };
    public ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;
    private final LinkedHashMap<class_2561, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    private final List<class_3545<class_2561, Integer>> tabs;
    private SearchFieldEntry searchFieldEntry;
    private class_339 buttonLeftTab;
    private class_339 buttonRightTab;
    private Rectangle tabsBounds;
    private Rectangle tabsLeftBounds;
    private Rectangle tabsRightBounds;
    private double tabsMaximumScrolled = -1.0;
    private final List<ClothConfigTabButton> tabButtons = Lists.newArrayList();
    private final Map<String, ConfigCategory> categoryMap;

    @ApiStatus.Internal
    public ClothConfigScreen(class_437 parent, class_2561 title, Map<String, ConfigCategory> categoryMap, class_2960 backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof class_3545 ? (AbstractConfigListEntry)((class_3545)object).method_15441() : (AbstractConfigListEntry)object;
                entry.setScreen(this);
                entries.add(entry);
            }
            this.categorizedEntries.put(category.getCategoryKey(), entries);
            if (category.getBackground() != null) {
                this.registerCategoryBackground(category.getCategoryKey().getString(), category.getBackground());
                this.registerCategoryTransparency(category.getCategoryKey().getString(), false);
            }
        });
        this.tabs = this.categorizedEntries.keySet().stream().map(s -> new class_3545(s, (Object)(class_310.method_1551().field_1772.method_27525((class_5348)s) + 8))).collect(Collectors.toList());
        this.categoryMap = categoryMap;
    }

    @Override
    public class_2561 getSelectedCategory() {
        return (class_2561)this.tabs.get(this.selectedCategoryIndex).method_15442();
    }

    @Override
    public Map<class_2561, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void method_25426() {
        super.method_25426();
        this.tabButtons.clear();
        this.listWidget = new ListWidget(this, this.field_22787, this.field_22789, this.field_22790, this.isShowingTabs() ? 70 : 30, this.field_22790 - 32, this.getBackgroundLocation());
        this.childrenL().add((class_364)this.listWidget);
        this.listWidget.method_25396().add(new EmptyEntry(5));
        this.searchFieldEntry = new SearchFieldEntry(this, this.listWidget);
        this.listWidget.method_25396().add(this.searchFieldEntry);
        this.listWidget.method_25396().add(new EmptyEntry(5));
        if (this.categorizedEntries.size() > this.selectedCategoryIndex) {
            this.listWidget.method_25396().addAll((List)Lists.newArrayList(this.categorizedEntries.values()).get(this.selectedCategoryIndex));
        }
        int buttonWidths = Math.min(200, (this.field_22789 - 50 - 12) / 3);
        this.method_37063((class_364)class_4185.method_46430((class_2561)(this.isEdited() ? class_2561.method_43471((String)"text.cloth-config.cancel_discard") : class_2561.method_43471((String)"gui.cancel")), widget -> this.quit()).method_46434(this.field_22789 / 2 - buttonWidths - 3, this.field_22790 - 26, buttonWidths, 20).method_46431());
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 3, this.field_22790 - 26, buttonWidths, 20, (class_2561)class_2561.method_43473(), button -> this.saveAll(true), Supplier::get){

            public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                for (List entries : Lists.newArrayList(ClothConfigScreen.this.categorizedEntries.values())) {
                    for (AbstractConfigEntry entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break;
                    }
                    if (!hasErrors) continue;
                    break;
                }
                this.field_22763 = ClothConfigScreen.this.isEdited() && !hasErrors;
                this.method_25355((class_2561)(hasErrors ? class_2561.method_43471((String)"text.cloth-config.error_cannot_save") : class_2561.method_43471((String)"text.cloth-config.save_and_done")));
                super.method_48579(graphics, mouseX, mouseY, delta);
            }
        });
        if (this.isShowingTabs()) {
            this.tabsBounds = new Rectangle(0, 41, this.field_22789, 24);
            this.tabsLeftBounds = new Rectangle(0, 41, 18, 24);
            this.tabsRightBounds = new Rectangle(this.field_22789 - 18, 41, 18, 24);
            this.buttonLeftTab = new class_4185(this, 4, 44, 12, 18, (class_2561)class_2561.method_43473(), button -> this.tabsScroller.scrollTo(0.0, true), Supplier::get){

                public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
                    graphics.method_25291(class_10799.field_56883, AbstractConfigScreen.CONFIG_TEX, this.method_46426(), this.method_46427(), 12.0f, (float)(18 * (!this.method_37303() ? 0 : (this.method_25367() ? 2 : 1))), this.field_22758, this.field_22759, 256, 256, class_9848.method_61317((float)this.field_22765));
                }
            };
            this.childrenL().add((class_364)this.buttonLeftTab);
            int j = 0;
            for (class_3545<class_2561, Integer> tab : this.tabs) {
                this.tabButtons.add(new ClothConfigTabButton(this, j, -100, 43, (Integer)tab.method_15441(), 20, (class_2561)tab.method_15442(), this.categoryMap.get(((class_2561)tab.method_15442()).getString()).getDescription()));
                ++j;
            }
            this.childrenL().addAll(this.tabButtons);
            this.buttonRightTab = new class_4185(this, this.field_22789 - 16, 44, 12, 18, (class_2561)class_2561.method_43473(), button -> this.tabsScroller.scrollTo(this.tabsScroller.getMaxScroll(), true), Supplier::get){

                public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
                    graphics.method_25291(class_10799.field_56883, AbstractConfigScreen.CONFIG_TEX, this.method_46426(), this.method_46427(), 0.0f, (float)(18 * (!this.method_37303() ? 0 : (this.method_25367() ? 2 : 1))), this.field_22758, this.field_22759, 256, 256, class_9848.method_61317((float)this.field_22765));
                }
            };
            this.childrenL().add((class_364)this.buttonRightTab);
        } else {
            this.tabsLeftBounds = this.tabsRightBounds = new Rectangle();
            this.tabsBounds = this.tabsRightBounds;
        }
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    @Override
    public boolean matchesSearch(Iterator<String> tags) {
        return this.searchFieldEntry.matchesSearch(tags);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.tabsBounds.contains(mouseX, mouseY) && !this.tabsLeftBounds.contains(mouseX, mouseY) && !this.tabsRightBounds.contains(mouseX, mouseY) && amountY != 0.0) {
            this.tabsScroller.offset(-amountY * 16.0, true);
            return true;
        }
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }

    public double getTabsMaximumScrolled() {
        if (this.tabsMaximumScrolled == -1.0) {
            int[] i = new int[]{0};
            for (class_3545<class_2561, Integer> pair : this.tabs) {
                i[0] = i[0] + ((Integer)pair.method_15441() + 2);
            }
            this.tabsMaximumScrolled = i[0];
        }
        return this.tabsMaximumScrolled + 6.0;
    }

    public void resetTabsMaximumScrolled() {
        this.tabsMaximumScrolled = -1.0;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.isShowingTabs()) {
            this.tabsScroller.updatePosition(delta * 3.0f);
            int xx = 24 - this.tabsScroller.scrollAmountInt();
            for (ClothConfigTabButton tabButton : this.tabButtons) {
                tabButton.method_46421(xx);
                xx += tabButton.method_25368() + 2;
            }
            this.buttonLeftTab.field_22763 = this.tabsScroller.scrollAmount() > 0.0;
            boolean bl = this.buttonRightTab.field_22763 = this.tabsScroller.scrollAmount() < this.getTabsMaximumScrolled() - (double)this.field_22789 + 40.0;
        }
        if (!this.isTransparentBackground()) {
            this.method_57735(graphics);
        } else {
            if (this.field_22787.field_1687 == null) {
                this.method_57728(graphics, delta);
            }
            this.method_57734(graphics);
            this.method_57735(graphics);
        }
        this.listWidget.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_44379(this.listWidget.left, this.listWidget.top, this.listWidget.left + this.listWidget.width, this.listWidget.bottom);
        for (AbstractConfigEntry<AbstractConfigEntry<?>> abstractConfigEntry : this.listWidget.method_25396()) {
            abstractConfigEntry.lateRender(graphics, mouseX, mouseY, delta);
        }
        graphics.method_44380();
        if (this.isShowingTabs()) {
            graphics.method_27534(this.field_22787.field_1772, this.field_22785, this.field_22789 / 2, 18, -1);
            Rectangle onlyInnerTabBounds = new Rectangle(this.tabsBounds.x + 20, this.tabsBounds.y, this.tabsBounds.width - 40, this.tabsBounds.height);
            graphics.method_44379(onlyInnerTabBounds.x, onlyInnerTabBounds.y, onlyInnerTabBounds.getMaxX(), onlyInnerTabBounds.getMaxY());
            if (this.isTransparentBackground()) {
                graphics.method_25296(onlyInnerTabBounds.x, onlyInnerTabBounds.y, onlyInnerTabBounds.getMaxX(), onlyInnerTabBounds.getMaxY(), 0x68000000, 0x68000000);
            } else {
                this.overlayBackground(graphics, onlyInnerTabBounds, 32, 32, 32, 255);
            }
            this.tabButtons.forEach(widget -> widget.method_25394(graphics, mouseX, mouseY, delta));
            this.drawTabsShades(graphics, 0, this.isTransparentBackground() ? 120 : 255);
            graphics.method_44380();
            this.buttonLeftTab.method_25394(graphics, mouseX, mouseY, delta);
            this.buttonRightTab.method_25394(graphics, mouseX, mouseY, delta);
        } else {
            graphics.method_27534(this.field_22787.field_1772, this.field_22785, this.field_22789 / 2, 12, -1);
        }
        if (this.isEditable()) {
            ArrayList errors = Lists.newArrayList();
            for (List entries : Lists.newArrayList(this.categorizedEntries.values())) {
                for (AbstractConfigEntry entry : entries) {
                    if (!entry.getConfigError().isPresent()) continue;
                    errors.add(entry.getConfigError().get());
                }
            }
            if (errors.size() > 0) {
                String string = "\u00a7c" + (errors.size() == 1 ? ((class_2561)errors.get(0)).method_27662().getString() : class_1074.method_4662((String)"text.cloth-config.multi_error", (Object[])new Object[0]));
                if (this.isTransparentBackground()) {
                    int stringWidth = this.field_22787.field_1772.method_1727(string);
                    Objects.requireNonNull(this.field_22787.field_1772);
                    graphics.method_25296(8, 9, 20 + stringWidth, 14 + 9, 0x68000000, 0x68000000);
                }
                graphics.method_25290(class_10799.field_56883, CONFIG_TEX, 10, 10, 0.0f, 54.0f, 3, 11, 256, 256);
                graphics.method_25303(this.field_22787.field_1772, string, 18, 12, -1);
                if (errors.size() > 1) {
                    int stringWidth = this.field_22787.field_1772.method_1727(string);
                    if (mouseX >= 10 && mouseY >= 10 && mouseX <= 18 + stringWidth) {
                        Objects.requireNonNull(this.field_22787.field_1772);
                        if (mouseY <= 14 + 9) {
                            this.addTooltip(Tooltip.of(new Point(mouseX, mouseY), errors.toArray(new class_2561[0])));
                        }
                    }
                }
            }
        } else if (!this.isEditable()) {
            String text = "\u00a7c" + class_1074.method_4662((String)"text.cloth-config.not_editable", (Object[])new Object[0]);
            if (this.isTransparentBackground()) {
                int n = this.field_22787.field_1772.method_1727(text);
                Objects.requireNonNull(this.field_22787.field_1772);
                graphics.method_25296(8, 9, 20 + n, 14 + 9, 0x68000000, 0x68000000);
            }
            graphics.method_25290(class_10799.field_56883, CONFIG_TEX, 10, 10, 0.0f, 54.0f, 3, 11, 256, 256);
            graphics.method_25303(this.field_22787.field_1772, text, 18, 12, -1);
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }

    private void drawTabsShades(class_332 graphics, int lightColor, int darkColor) {
        graphics.method_25290(class_10799.field_56883, class_437.field_49895, this.tabsBounds.getMinX() - 20, this.tabsBounds.getMinY() - 2, 0.0f, 0.0f, this.tabsBounds.getWidth() + 40, 2, 32, 2);
        graphics.method_25290(class_10799.field_56883, class_437.field_49896, this.tabsBounds.getMinX() - 20, this.tabsBounds.getMaxY(), 0.0f, 0.0f, this.tabsBounds.getWidth() + 40, 2, 32, 2);
    }

    @Override
    public void save() {
        super.save();
    }

    @Override
    public boolean isEditable() {
        return super.isEditable();
    }

    public static class ListWidget<R extends DynamicElementListWidget.ElementEntry<R>>
    extends DynamicElementListWidget<R> {
        private final AbstractConfigScreen screen;
        private final ValueAnimator<Rectangle> currentBounds = ValueAnimator.ofRectangle();
        public UnaryOperator<List<R>> entriesTransformer = UnaryOperator.identity();
        public Rectangle thisTimeTarget;
        public long lastTouch;

        public ListWidget(AbstractConfigScreen screen, class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
            super(client, width, height, top, bottom, screen.isTransparentBackground() ? null : backgroundLocation);
            this.setRenderSelection(false);
            this.screen = screen;
        }

        @Override
        public int getItemWidth() {
            return this.width - 80;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.left + this.width - 36;
        }

        @Override
        protected void renderItem(class_332 graphics, R item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (item instanceof AbstractConfigEntry) {
                ((AbstractConfigEntry)item).updateSelected(this.getFocused() == item);
            }
            super.renderItem(graphics, item, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        @Override
        protected void renderList(class_332 graphics, int startX, int startY, int mouseX, int mouseY, float delta) {
            this.thisTimeTarget = null;
            Rectangle hoverBounds = (Rectangle)this.currentBounds.value();
            if (!hoverBounds.isEmpty()) {
                long timePast = System.currentTimeMillis() - this.lastTouch;
                int alpha = timePast <= 200L ? 255 : class_3532.method_15384((double)(255.0 - (double)(Math.min((float)(timePast - 200L), 500.0f) / 500.0f) * 255.0));
                alpha = alpha * 36 / 255 << 24;
                graphics.method_25296(hoverBounds.x, hoverBounds.y - (int)this.scroll, hoverBounds.getMaxX(), hoverBounds.getMaxY() - (int)this.scroll, 0xFFFFFF | alpha, 0xFFFFFF | alpha);
            }
            super.renderList(graphics, startX, startY, mouseX, mouseY, delta);
            if (this.thisTimeTarget != null && this.method_25405(mouseX, mouseY)) {
                this.lastTouch = System.currentTimeMillis();
            }
            if (this.thisTimeTarget != null && !this.thisTimeTarget.equals(this.currentBounds.target())) {
                this.currentBounds.setTo(this.thisTimeTarget, 100L);
            } else if (!((Rectangle)this.currentBounds.target()).isEmpty()) {
                this.currentBounds.update(delta);
            }
        }

        protected static void fillGradient(Matrix4f matrix, class_287 bufferBuilder, double xStart, double yStart, double xEnd, double yEnd, int i, int j, int k) {
            float f = (float)(j >> 24 & 0xFF) / 255.0f;
            float g = (float)(j >> 16 & 0xFF) / 255.0f;
            float h = (float)(j >> 8 & 0xFF) / 255.0f;
            float l = (float)(j & 0xFF) / 255.0f;
            float m = (float)(k >> 24 & 0xFF) / 255.0f;
            float n = (float)(k >> 16 & 0xFF) / 255.0f;
            float o = (float)(k >> 8 & 0xFF) / 255.0f;
            float p = (float)(k & 0xFF) / 255.0f;
            bufferBuilder.method_22918(matrix, (float)xEnd, (float)yStart, (float)i).method_22915(g, h, l, f);
            bufferBuilder.method_22918(matrix, (float)xStart, (float)yStart, (float)i).method_22915(g, h, l, f);
            bufferBuilder.method_22918(matrix, (float)xStart, (float)yEnd, (float)i).method_22915(n, o, p, m);
            bufferBuilder.method_22918(matrix, (float)xEnd, (float)yEnd, (float)i).method_22915(n, o, p, m);
        }

        @Override
        public boolean method_25402(class_11909 event, boolean doubleClick) {
            this.updateScrollingState(event.comp_4798(), event.comp_4799(), event.comp_4800().comp_4801());
            if (!this.method_25405(event.comp_4798(), event.comp_4799())) {
                return false;
            }
            for (DynamicElementListWidget.ElementEntry entry : this.method_25396()) {
                if (!entry.method_25402(event, doubleClick)) continue;
                this.method_25395(entry);
                this.method_25398(true);
                return true;
            }
            if (event.method_74245() == 0) {
                this.clickedHeader((int)(event.comp_4798() - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(event.comp_4799() - (double)this.top) + (int)this.getScroll() - 4);
                return true;
            }
            return this.scrolling;
        }

        @Override
        public List<R> method_25396() {
            return (List)this.entriesTransformer.apply(super.method_25396());
        }
    }
}

