/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric.network;

import io.github.kosmx.emotes.arch.mixin.ServerCommonPacketListenerAccessor;
import io.github.kosmx.emotes.arch.network.CommonServerNetworkHandler;
import io.github.kosmx.emotes.arch.network.ConfigTask;
import io.github.kosmx.emotes.arch.network.EmotePacketPayload;
import io.github.kosmx.emotes.arch.network.EmotesMixinConnection;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.fabric.network.PayloadTypeRegistator;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.IOException;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_8605;
import net.minecraft.class_8610;

public final class ServerNetworkStuff {
    public static void init() {
        PayloadTypeRegistator.init();
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, NetworkPlatformTools.EMOTE_CHANNEL_ID)) {
                handler.addTask((class_8605)new ConfigTask());
            } else {
                CommonData.LOGGER.debug("Client doesn't support emotes, ignoring");
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(NetworkPlatformTools.EMOTE_CHANNEL_ID, (payload, context) -> {
            try {
                NetData message = payload.packet().data;
                if (message.purpose != PacketTask.CONFIG) {
                    throw new IOException("Wrong packet type for config task");
                }
                ((EmotesMixinConnection)((ServerCommonPacketListenerAccessor)context.networkHandler()).getConnection()).emotecraft$setVersions(message.versions);
                UniversalEmoteSerializer.preparePackets(message.versions).map(EmotePacketPayload::playPacket).forEach(arg_0 -> ((PacketSender)context.responseSender()).sendPacket(arg_0));
                context.networkHandler().completeTask(ConfigTask.TYPE);
            }
            catch (IOException e) {
                CommonData.LOGGER.error("", (Throwable)e);
                context.networkHandler().method_52396((class_2561)class_2561.method_43470((String)("emotecraft: " + e.getMessage())));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(NetworkPlatformTools.EMOTE_CHANNEL_ID, (buf, context) -> CommonServerNetworkHandler.getInstance().receiveMessage(buf.packet(), (class_1657)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(NetworkPlatformTools.STREAM_CHANNEL_ID, (buf, context) -> CommonServerNetworkHandler.getInstance().receiveStreamMessage(buf.packet(), (class_1657)context.player()));
    }
}

