/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.mc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.api.events.server.ServerEmoteAPI;
import io.github.kosmx.emotes.mc.EmoteArgumentProvider;
import io.github.kosmx.emotes.mc.services.IPermissionService;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_11890;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public final class ServerCommands {
    public static final List<String> PERMISSIONS = List.of("emotes.play.player", "emotes.stop.player", "emotes.stop.forced", "emotes.play.showhidden", "emotes.reload");

    public static <T> void register(CommandDispatcher<T> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        ServerCommands.register(dispatcher, environment == class_2170.class_5364.field_25420);
    }

    public static <T> void register(CommandDispatcher<T> dispatcher, boolean isDedicated) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"emotes").then(class_2170.method_9247((String)"play").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"emote", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new EmoteArgumentProvider(ServerCommands::getEmotes)).executes(context -> {
            UUID player = ((class_2168)context.getSource()).method_9207().method_5667();
            boolean admin = IPermissionService.INSTANCE.check((class_2168)context.getSource(), "emotes.stop.forced", 2);
            if (!admin && ServerEmoteAPI.isForcedEmote(player)) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Can't stop forced emote without admin rights")).create();
            }
            Animation emote = EmoteArgumentProvider.getEmote(ServerCommands.getEmotes((CommandContext<class_2168>)context), (CommandContext<class_2168>)context, "emote");
            ServerEmoteAPI.playEmote(player, emote, false);
            return 0;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"avatar", (ArgumentType)class_2186.method_9306()).requires(IPermissionService.INSTANCE.require("emotes.play.player", 2))).executes(context -> {
            ServerEmoteAPI.playEmote(ServerCommands.getAvatar((CommandContext<class_2168>)context, "avatar").method_5667(), EmoteArgumentProvider.getEmote(ServerCommands.getEmotes((CommandContext<class_2168>)context), (CommandContext<class_2168>)context, "emote"), false);
            return 0;
        })).then(class_2170.method_9244((String)"forced", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerEmoteAPI.playEmote(ServerCommands.getAvatar((CommandContext<class_2168>)context, "avatar").method_5667(), EmoteArgumentProvider.getEmote(ServerCommands.getEmotes((CommandContext<class_2168>)context), (CommandContext<class_2168>)context, "emote"), BoolArgumentType.getBool((CommandContext)context, (String)"forced"));
            return 0;
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").executes(context -> {
            boolean admin = IPermissionService.INSTANCE.check((class_2168)context.getSource(), "emotes.stop.forced", 2);
            UUID player = ((class_2168)context.getSource()).method_9207().method_5667();
            if (admin || !ServerEmoteAPI.isForcedEmote(player)) {
                ServerEmoteAPI.playEmote(player, null, false);
                return 0;
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Can't stop forced emote without admin rights")).create();
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"avatar", (ArgumentType)class_2186.method_9309()).requires(IPermissionService.INSTANCE.require("emotes.stop.player", 2))).executes(context -> {
            ServerEmoteAPI.playEmote(ServerCommands.getAvatar((CommandContext<class_2168>)context, "avatar").method_5667(), null, false);
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(ctx -> IPermissionService.INSTANCE.check((class_2168)ctx, "emotes.reload", 4) && isDedicated)).executes(context -> {
            UniversalEmoteSerializer.loadEmotes();
            return 0;
        })));
    }

    private static Map<UUID, Animation> getEmotes(CommandContext<class_2168> context) {
        return IPermissionService.INSTANCE.check((class_2168)context.getSource(), "emotes.play.showhidden", 1) ? UniversalEmoteSerializer.getLoadedEmotes() : UniversalEmoteSerializer.SERVER_EMOTES;
    }

    public static class_11890 getAvatar(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        class_1297 class_12972 = class_2186.method_9313(context, (String)name);
        if (class_12972 instanceof class_11890) {
            class_11890 avatar = (class_11890)class_12972;
            return avatar;
        }
        throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"The specified entity must be an avatar!")).create();
    }
}

