/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.config.cloth;

import ca.fxco.moreculling.config.cloth.MoreCullingClothConfigCategory;
import ca.fxco.moreculling.config.cloth.MoreCullingClothConfigScreen;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

public class MoreCullingClothConfigBuilder
implements ConfigBuilder {
    private Runnable savingRunnable;
    private class_437 parent;
    private class_2561 title = class_2561.method_43471((String)"moreculling.title");
    private boolean editable = true;
    private boolean tabsSmoothScroll = true;
    private boolean listSmoothScroll = true;
    private boolean doesConfirmSave = true;
    private boolean transparentBackground = false;
    private class_2960 defaultBackground = class_437.field_49511;
    private Consumer<class_437> afterInitConsumer = screen -> {};
    protected final Map<String, ConfigCategory> categoryMap = Maps.newLinkedHashMap();
    private String fallbackCategory = null;
    private boolean alwaysShowTabs = false;

    public static ConfigBuilder create() {
        return new MoreCullingClothConfigBuilder();
    }

    @ApiStatus.Internal
    public MoreCullingClothConfigBuilder() {
    }

    public boolean isAlwaysShowTabs() {
        return this.alwaysShowTabs;
    }

    public ConfigBuilder setAlwaysShowTabs(boolean alwaysShowTabs) {
        this.alwaysShowTabs = alwaysShowTabs;
        return this;
    }

    public ConfigBuilder setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
        return this;
    }

    public boolean hasTransparentBackground() {
        return this.transparentBackground;
    }

    public ConfigBuilder setAfterInitConsumer(Consumer<class_437> afterInitConsumer) {
        this.afterInitConsumer = afterInitConsumer;
        return this;
    }

    public void setGlobalized(boolean b) {
    }

    public void setGlobalizedExpanded(boolean b) {
    }

    public ConfigBuilder setFallbackCategory(ConfigCategory fallbackCategory) {
        this.fallbackCategory = Objects.requireNonNull(fallbackCategory).getCategoryKey().getString();
        return this;
    }

    public class_437 getParentScreen() {
        return this.parent;
    }

    public ConfigBuilder setParentScreen(class_437 parent) {
        this.parent = parent;
        return this;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public ConfigBuilder setTitle(class_2561 title) {
        this.title = title;
        return this;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public ConfigBuilder setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public ConfigCategory getOrCreateCategory(class_2561 categoryKey) {
        if (this.categoryMap.containsKey(categoryKey.getString())) {
            return this.categoryMap.get(categoryKey.getString());
        }
        if (this.fallbackCategory == null) {
            this.fallbackCategory = categoryKey.getString();
        }
        return this.categoryMap.computeIfAbsent(categoryKey.getString(), key -> new MoreCullingClothConfigCategory(this, categoryKey));
    }

    public ConfigBuilder removeCategory(class_2561 category) {
        if (this.categoryMap.containsKey(category.getString()) && Objects.equals(this.fallbackCategory, category.getString())) {
            this.fallbackCategory = null;
        }
        if (!this.categoryMap.containsKey(category.getString())) {
            throw new NullPointerException("Category doesn't exist!");
        }
        this.categoryMap.remove(category.getString());
        return this;
    }

    public ConfigBuilder removeCategoryIfExists(class_2561 category) {
        if (this.categoryMap.containsKey(category.getString()) && Objects.equals(this.fallbackCategory, category.getString())) {
            this.fallbackCategory = null;
        }
        this.categoryMap.remove(category.getString());
        return this;
    }

    public boolean hasCategory(class_2561 category) {
        return this.categoryMap.containsKey(category.getString());
    }

    public ConfigBuilder setShouldTabsSmoothScroll(boolean shouldTabsSmoothScroll) {
        this.tabsSmoothScroll = shouldTabsSmoothScroll;
        return this;
    }

    public boolean isTabsSmoothScrolling() {
        return this.tabsSmoothScroll;
    }

    public ConfigBuilder setShouldListSmoothScroll(boolean shouldListSmoothScroll) {
        this.listSmoothScroll = shouldListSmoothScroll;
        return this;
    }

    public boolean isListSmoothScrolling() {
        return this.listSmoothScroll;
    }

    public ConfigBuilder setDoesConfirmSave(boolean confirmSave) {
        this.doesConfirmSave = confirmSave;
        return this;
    }

    public boolean doesConfirmSave() {
        return this.doesConfirmSave;
    }

    public class_2960 getDefaultBackgroundTexture() {
        return this.defaultBackground;
    }

    public ConfigBuilder setDefaultBackgroundTexture(class_2960 texture) {
        this.defaultBackground = texture;
        return this;
    }

    public ConfigBuilder setSavingRunnable(Runnable runnable) {
        this.savingRunnable = runnable;
        return this;
    }

    public Consumer<class_437> getAfterInitConsumer() {
        return this.afterInitConsumer;
    }

    public class_437 build() {
        if (!this.categoryMap.isEmpty() && this.fallbackCategory != null) {
            MoreCullingClothConfigScreen screen = new MoreCullingClothConfigScreen(this.parent, this.title, this.categoryMap, this.defaultBackground);
            screen.setSavingRunnable(this.savingRunnable);
            screen.setEditable(this.editable);
            screen.setFallbackCategory((class_2561)(this.fallbackCategory == null ? null : class_2561.method_43470((String)this.fallbackCategory)));
            screen.setTransparentBackground(this.transparentBackground);
            screen.setAlwaysShowTabs(this.alwaysShowTabs);
            screen.setConfirmSave(this.doesConfirmSave);
            screen.setAfterInitConsumer(this.afterInitConsumer);
            return screen;
        }
        throw new NullPointerException("There cannot be no categories or fallback category!");
    }

    public Runnable getSavingRunnable() {
        return this.savingRunnable;
    }
}

