/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.MicrophoneProcessor;
import de.maxhenkel.voicechat.voice.common.AudioUtils;

public class VoiceMicrophoneProcessor
extends MicrophoneProcessor {
    public static final float ACTIVATION_PROBABILITY = 0.5f;
    private boolean testing;

    @Override
    public int getDeactivationDelay() {
        return VoicechatClient.CLIENT_CONFIG.voiceDeactivationDelay.get();
    }

    @Override
    protected boolean processInternal(short[] audio, boolean testing) {
        this.testing = testing;
        if (this.isMuted() && !testing) {
            this.reset();
            return false;
        }
        if (this.denoiserAvailable() && VoicechatClient.CLIENT_CONFIG.vad.get().booleanValue()) {
            return this.speechProbability >= 0.5f;
        }
        return AudioUtils.isAboveThreshold(audio, VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.get());
    }

    @Override
    protected boolean shouldAdjustGain() {
        return !this.isMuted() || this.testing;
    }

    @Override
    public MicrophoneActivationType getActivationType() {
        return MicrophoneActivationType.VOICE;
    }
}

