/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kostromdan.mods.crash_assistant.common.CrashAssistant;
import dev.kostromdan.mods.crash_assistant.common.utils.ManualCrashThrower;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiffStringBuilder;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.utils.HeapDumper;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ThreadDumper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3673;
import net.minecraft.class_5250;

public class CrashAssistantCommands {
    public static final HashMap<String, String> supportedCrashCommands = new HashMap<String, String>(){
        {
            this.put("game", "Minecraft");
            this.put("jvm", "JVM");
            this.put("no_crash", "noCrash");
        }
    };
    public static final HashSet<String> supportedCrashArgs = new HashSet<String>(){
        {
            this.add("--withThreadDump");
            this.add("--withHeapDump");
            this.add("--GCBeforeHeapDump");
        }
    };
    public static Instant lastCrashCommand = Instant.ofEpochMilli(0L);
    public static boolean isDeadLocked = false;

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"crash_assistant").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"modlist").then(LiteralArgumentBuilder.literal((String)"save").executes(CrashAssistantCommands::saveModlist))).then(LiteralArgumentBuilder.literal((String)"diff").executes(CrashAssistantCommands::showDiff)))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"crash").requires(c -> CrashAssistantConfig.getBoolean("crash_command.enabled"))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"to_crash", (ArgumentType)StringArgumentType.string()).suggests(new CrashCommandsSuggestionProvider()).executes(CrashAssistantCommands::crash)).then(CrashAssistantCommands.getCrashArg(1).then(CrashAssistantCommands.getCrashArg(2).then(CrashAssistantCommands.getCrashArg(3))))));
    }

    public static class_2561 getModConfigComponent() {
        return class_2561.method_43470((String)"[mod config]").method_27694(style -> style.method_10977(class_124.field_1054).method_10958((class_2558)new class_2558.class_10607(CrashAssistantConfig.getConfigPath())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.mod_config_tooltip")))));
    }

    public static class_2561 getCopyNicknameComponent(String playerNickname) {
        return class_2561.method_43470((String)"[nickname]").method_27694(style -> style.method_10977(class_124.field_1054).method_10958((class_2558)new class_2558.class_10606("\"" + playerNickname + "\"")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.nickname_tooltip")))));
    }

    public static class_2561 getCopyDiffComponent(ModListDiffStringBuilder diff) {
        return class_2561.method_43470((String)("[" + LanguageProvider.get("commands.diff_copy") + "]")).method_27694(style -> style.method_10977(class_124.field_1054).method_10958((class_2558)new class_2558.class_10606(diff.toText())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.diff_tooltip")))));
    }

    public static void sendClientMsg(class_2561 message) {
        class_310.method_1551().execute(() -> class_310.method_1551().field_1705.method_1743().method_1812(message));
    }

    public static boolean checkModlistFeatureEnabled() {
        LanguageProvider.updateLang();
        if (CrashAssistantConfig.getBoolean("modpack_modlist.enabled")) {
            return true;
        }
        class_5250 msg = class_2561.method_43473();
        msg.method_10852((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.modlist_disabled_error_msg")));
        msg.method_10852(CrashAssistantCommands.getModConfigComponent());
        msg.method_27692(class_124.field_1061);
        CrashAssistantCommands.sendClientMsg((class_2561)msg);
        return false;
    }

    public static int saveModlist(CommandContext<?> context) {
        if (!CrashAssistantCommands.checkModlistFeatureEnabled()) {
            return 0;
        }
        class_5250 msg = class_2561.method_43473();
        if (CrashAssistantConfig.getModpackCreators().contains(CrashAssistant.playerNickname)) {
            ModListUtils.saveCurrentModList();
            msg.method_10852((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.modlist_overwritten_success")));
            if (CrashAssistantConfig.getBoolean("modpack_modlist.auto_update")) {
                msg.method_10852((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.modlist_auto_update_msg")).method_27694(style -> style.method_10977(class_124.field_1068)));
            } else {
                msg.method_10852((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.modlist_enable_auto_update_msg")).method_27694(style -> style.method_10977(class_124.field_1068)));
            }
            msg.method_10852(CrashAssistantCommands.getModConfigComponent());
            msg.method_27692(class_124.field_1060);
        } else {
            msg.method_10852((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.not_creator_error_msg")));
            msg.method_10852(CrashAssistantCommands.getCopyNicknameComponent(CrashAssistant.playerNickname));
            msg.method_10852((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.add_to_creator_list_msg")));
            msg.method_10852(CrashAssistantCommands.getModConfigComponent());
            msg.method_27692(class_124.field_1061);
        }
        CrashAssistantCommands.sendClientMsg((class_2561)msg);
        return 0;
    }

    public static int showDiff(CommandContext<?> context) {
        if (!CrashAssistantCommands.checkModlistFeatureEnabled()) {
            return 0;
        }
        ModListDiff diff = ModListDiff.getDiff(false);
        class_5250 msg = new ComponentModListDiffStringBuilder(diff.generateDiffMsg(false)).toComponent();
        msg.method_10852(CrashAssistantCommands.getCopyDiffComponent(diff.generateDiffMsg(true)));
        CrashAssistantCommands.sendClientMsg((class_2561)msg);
        return 0;
    }

    private static int deadlockIntegratedServer(CommandContext<?> context) {
        class_310.method_1551().method_1576().execute(() -> {
            isDeadLocked = true;
            while (isDeadLocked) {
            }
        });
        return 0;
    }

    private static int releaseIntegratedServer(CommandContext<?> context) {
        isDeadLocked = false;
        return 0;
    }

    public static int crash(CommandContext<?> context) {
        LanguageProvider.updateLang();
        class_5250 msg = class_2561.method_43473();
        String toCrash = "null";
        try {
            toCrash = (String)context.getArgument("to_crash", String.class);
            if (!supportedCrashCommands.containsKey(toCrash)) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException ignored) {
            CrashAssistantCommands.sendClientMsg((class_2561)class_2561.method_43470((String)(LanguageProvider.get("commands.crash_command_validation_failed_to_crash") + " '" + toCrash + "'")).method_27694(style -> style.method_10977(class_124.field_1061)));
            return 0;
        }
        toCrash = supportedCrashCommands.get(toCrash);
        int secondsToCrash = (Integer)CrashAssistantConfig.get("crash_command.seconds");
        boolean noCrash = Objects.equals(toCrash, "noCrash");
        if (secondsToCrash <= 0 || Instant.now().isBefore(lastCrashCommand.plusSeconds(secondsToCrash)) || noCrash) {
            List<String> args = CrashAssistantCommands.parseCrashArgs(context);
            String finalToCrash = toCrash;
            new Thread(() -> {
                if (!CrashAssistantCommands.validateCrashArgs(args)) {
                    return;
                }
                if (!args.isEmpty()) {
                    CrashAssistantCommands.sendClientMsg((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.crash_command_applying_args")).method_27694(style -> style.method_10977(class_124.field_1054)));
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (args.contains("--withThreadDump")) {
                    CrashAssistant.LOGGER.error("Detected '--withThreadDump' crash command argument. ThreadDump:\n" + ThreadDumper.obtainThreadDump());
                }
                if (args.contains("--withHeapDump")) {
                    if (args.contains("--GCBeforeHeapDump")) {
                        CrashAssistant.LOGGER.error("Detected '--GCBeforeHeapDump' crash command argument. Performing garbage collection before heap dump.");
                        System.gc();
                    }
                    CrashAssistant.LOGGER.error("Detected '--withHeapDump' crash command argument. Creating heap dump.");
                    try {
                        CrashAssistant.LOGGER.error("Created heap dump at: " + HeapDumper.createHeapDump());
                    }
                    catch (Exception e) {
                        CrashAssistant.LOGGER.error("Failed to create heap dump.", (Throwable)e);
                    }
                }
                if (!noCrash) {
                    CrashAssistantCommands.sendClientMsg((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.crash_command_crashing")).method_27694(style -> style.method_10977(class_124.field_1061)));
                } else {
                    CrashAssistantCommands.sendClientMsg((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.crash_command_done")));
                }
                if (Objects.equals(finalToCrash, "Minecraft")) {
                    class_310.method_1551().execute(() -> ManualCrashThrower.crashGame("Minecraft crashed by '/crash_assistant crash' command."));
                } else if (Objects.equals(finalToCrash, "JVM")) {
                    CrashAssistant.LOGGER.error("JVM crashed by '/crash_assistant crash jvm' command.");
                    class_3673.method_15973();
                }
            }).start();
            return 0;
        }
        lastCrashCommand = Instant.now();
        msg.method_10852((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.crash_command_1")));
        msg.method_10852((class_2561)class_2561.method_43470((String)toCrash).method_27694(style -> style.method_10977(class_124.field_1054)));
        msg.method_10852((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.crash_command_2")));
        msg.method_10852((class_2561)class_2561.method_43470((String)Integer.toString(secondsToCrash)).method_27694(style -> style.method_10977(class_124.field_1054)));
        msg.method_10852((class_2561)class_2561.method_43470((String)LanguageProvider.get("commands.crash_command_3")));
        msg.method_27694(style -> style.method_10977(class_124.field_1061));
        CrashAssistantCommands.sendClientMsg((class_2561)msg);
        return 0;
    }

    public static boolean validateCrashArgs(List<String> args) {
        for (String arg : args) {
            if (supportedCrashArgs.contains(arg)) continue;
            CrashAssistantCommands.sendClientMsg((class_2561)class_2561.method_43470((String)(LanguageProvider.get("commands.crash_command_validation_failed") + " '" + arg + "'")).method_27694(style -> style.method_10977(class_124.field_1061)));
            return false;
        }
        return true;
    }

    public static List<String> parseCrashArgs(CommandContext<?> context) {
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 1; i <= supportedCrashArgs.size(); ++i) {
            try {
                args.add((String)context.getArgument("arg" + i, String.class));
                continue;
            }
            catch (IllegalArgumentException ignored) {
                break;
            }
        }
        return args;
    }

    public static ArgumentBuilder getCrashArg(int i) {
        return RequiredArgumentBuilder.argument((String)("arg" + i), (ArgumentType)StringArgumentType.string()).suggests(new CrashArgsSuggestionProvider()).executes(CrashAssistantCommands::crash);
    }

    public static class CrashCommandsSuggestionProvider<S>
    implements SuggestionProvider<S> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (String crashCommand : supportedCrashCommands.keySet()) {
                builder.suggest(crashCommand);
            }
            return builder.buildFuture();
        }
    }

    public static class ComponentModListDiffStringBuilder
    extends ModListDiffStringBuilder {
        ComponentModListDiffStringBuilder(ModListDiffStringBuilder modListDiffStringBuilder) {
            this.sb = modListDiffStringBuilder.sb;
        }

        public class_5250 toComponent() {
            class_5250 msg = class_2561.method_43473();
            for (ModListDiffStringBuilder.ColoredString cs : this.sb) {
                if (cs.getColor().isEmpty()) {
                    msg.method_27693(cs.getText());
                } else {
                    msg.method_10852((class_2561)class_2561.method_43470((String)cs.getText()).method_27694(style -> style.method_10977(Enum.valueOf(class_124.class, cs.getColor().toUpperCase()))));
                }
                if (!cs.isEndsWithNewLine()) continue;
                msg.method_27693("\n");
            }
            return msg;
        }
    }

    public static class CrashArgsSuggestionProvider<S>
    implements SuggestionProvider<S> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            List<String> existingArgs = CrashAssistantCommands.parseCrashArgs(context);
            for (String e : supportedCrashArgs) {
                if (existingArgs.contains(e) || Objects.equals(e, "--GCBeforeHeapDump") && !existingArgs.contains("--withHeapDump")) continue;
                builder.suggest(e);
            }
            return builder.buildFuture();
        }
    }
}

