/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.communication;

import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public final class ProcessSignalIO {
    private static final Path BASE_DIR = Paths.get("local", "crash_assistant");

    private ProcessSignalIO() {
    }

    public static void post(String name, String data) {
        String fileName = name + "_pid" + ProcessHelper.getCurrentProcessId() + ".tmp";
        Path filePath = BASE_DIR.resolve(fileName);
        try {
            Files.write(filePath, data.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            JarInJarHelper.LOGGER.error("Error while saving data to {}", (Object)fileName, (Object)e);
        }
    }

    public static void post(String name) {
        ProcessSignalIO.post(name, Long.toString(System.currentTimeMillis()));
    }

    public static void postAsOtherProcess(String name, String data, long pid) {
        String fileName = name + "_pid" + pid + ".tmp";
        Path filePath = BASE_DIR.resolve(fileName);
        try {
            Files.write(filePath, data.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            JarInJarHelper.LOGGER.error("Error while saving data to {}", (Object)fileName, (Object)e);
        }
    }

    public static void postAsOtherProcess(String name, long pid) {
        ProcessSignalIO.postAsOtherProcess(name, Long.toString(System.currentTimeMillis()), pid);
    }

    public static Optional<String> get(String name, long pid) {
        String fileName = name + "_pid" + pid + ".tmp";
        Path filePath = BASE_DIR.resolve(fileName);
        if (!Files.isReadable(filePath)) {
            return Optional.empty();
        }
        try {
            byte[] bytes = Files.readAllBytes(filePath);
            String content = new String(bytes, StandardCharsets.UTF_8);
            return Optional.of(content);
        }
        catch (IOException e) {
            JarInJarHelper.LOGGER.error("Error while reading data from {}", (Object)fileName, (Object)e);
            return Optional.empty();
        }
    }

    public static boolean exists(String name, long pid) {
        String fileName = name + "_pid" + pid + ".tmp";
        Path filePath = BASE_DIR.resolve(fileName);
        return Files.isRegularFile(filePath, new LinkOption[0]);
    }

    public static void postInfo(String name, String data) {
        String fileName = name + ".info";
        Path filePath = BASE_DIR.resolve(fileName);
        try {
            Files.write(filePath, data.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            JarInJarHelper.LOGGER.error("Error while saving info to {}", (Object)fileName, (Object)e);
        }
    }

    public static Optional<String> getInfo(String name) {
        String fileName = name + ".info";
        Path filePath = BASE_DIR.resolve(fileName);
        if (!Files.isReadable(filePath)) {
            return Optional.empty();
        }
        try {
            byte[] bytes = Files.readAllBytes(filePath);
            String content = new String(bytes, StandardCharsets.UTF_8);
            return Optional.of(content);
        }
        catch (IOException e) {
            JarInJarHelper.LOGGER.error("Error while reading info from {}", (Object)fileName, (Object)e);
            return Optional.empty();
        }
    }

    public static boolean existsInfo(String name) {
        String fileName = name + ".info";
        Path filePath = BASE_DIR.resolve(fileName);
        return Files.isRegularFile(filePath, new LinkOption[0]);
    }

    static {
        try {
            Files.createDirectories(BASE_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            JarInJarHelper.LOGGER.error("Unable to create base directory {}", (Object)BASE_DIR, (Object)e);
        }
    }
}

